/*
 *	TMController.m
 *	"THE BEER-WARE LICENSE" (Revision 42):
 *	<devin at shiftedbits dot org> (Devin Lane) wrote this file.
 *	As long as you retain this notice you can do whatever you want with this stuff. 
 *	If we meet some day, and you think this stuff is worth it, you can buy me a beer in return.
 */

#import "TMController.h"

NSString *TMPath = @"/Applications/Time Machine.app/Contents/MacOS/Time Machine";

/* Command we can send to time machine
 * These are documented in /Applications/Time Machine.app/Contents/Resources/Menu.plist */
typedef enum _TMCommand {
	TMShowPreferences = 1,
	TMBackupNow = 2,
	TMStopBackup = 3,
	TMBrowseOtherDisks = 4
} TMCommand;

@implementation TMController

- (void)awakeFromNib
{
	item = [[[NSStatusBar systemStatusBar] statusItemWithLength:26.0] retain];
	
	/* Yes, the image looks like crap */
	NSImage *image = [NSImage imageNamed:@"tm"];
	[image setSize:NSMakeSize(18,18)];
	[image setScalesWhenResized:YES];
	
	[item setImage:image];
	[item setMenu:menu];
	[item setHighlightMode:YES];
}

- (void)dealloc
{
	[item release];
	[super dealloc];
}

- (void)sendCommandToTimeMachine:(TMCommand)command
{
	/* The Time Machine dockling takes an argument that tells it what to do */
	[NSTask launchedTaskWithLaunchPath:TMPath arguments:[NSArray arrayWithObject:[[NSNumber numberWithInt:command] stringValue]]];
}

- (IBAction)backupNow:(id)sender
{
	[self sendCommandToTimeMachine:TMBackupNow];
}
- (IBAction)showOtherDisks:(id)sender
{
	[self sendCommandToTimeMachine:TMBrowseOtherDisks];
}
- (IBAction)show:(id)sender
{
	/* This is the distributed notification that triggers time Machine */
	[[NSDistributedNotificationCenter defaultCenter] postNotificationName:@"com.apple.peabody.show" object:nil];
}
- (IBAction)showPrefs:(id)sender
{
	[self sendCommandToTimeMachine:TMShowPreferences];
}

@end
